//=============================================================================
// Poolball.
//=============================================================================
class GolfBall extends DeusExDecoration;

enum ESkinColor
{
	SC_1,
	SC_2,
	SC_3,
	SC_4,
	SC_5
};

var byte PowerMode;
var() ESkinColor SkinColor;
var bool bJustHit;

function BeginPlay()
{
	Super.BeginPlay();

	switch (SkinColor)
	{
		case SC_1:		Skin = Texture'PoolballTex1'; break;
		case SC_2:		Skin = Texture'PoolballTex2'; break;
		case SC_3:		Skin = Texture'PoolballTex3'; break;
		case SC_4:		Skin = Texture'PoolballTex4'; break;
		case SC_5:		Skin = Texture'PoolballTex5'; break;
	}
}

function Tick(float deltaTime)
{
	local float speed;

	speed = VSize(Velocity);

	if ((speed >= 0) && (speed < 5))
	{
		bFixedRotationDir = False;
		Velocity = vect(0,0,0);
	}
	else if (speed >= 5)
	{
		bFixedRotationDir = True;
		SetRotation(Rotator(Velocity));
		RotationRate.Pitch = speed * 60000;
	}
}

event HitWall(vector HitNormal, actor HitWall)
{
	local Vector newloc;

	// if we hit the ground, make sure we are rolling
	if (HitNormal.Z == 1.0)
	{
		SetPhysics(PHYS_Rolling, HitWall);
		if (Physics == PHYS_Rolling)
		{
			bFixedRotationDir = False;
			Velocity = vect(0,0,0);
			return;
		}
	}

	Velocity = 0.9*((Velocity dot HitNormal) * HitNormal * (-2.0) + Velocity);   // Reflect off Wall w/damping
	Velocity.Z = 0;
	newloc = Location + HitNormal;	// move it out from the wall a bit
	SetLocation(newloc);
}

function Timer()
{
	bJustHit = False;
}

function Bump(actor Other)
{
	local Vector HitNormal;

	if (Other.IsA('Poolball'))
	{
		if (!Poolball(Other).bJustHit)
		{
			PlaySound(sound'PoolballClack', SLOT_None);
			HitNormal = Normal(Location - Other.Location);
			Velocity = HitNormal * VSize(Other.Velocity);
			Velocity.Z = 0;
			bJustHit = True;
			Poolball(Other).bJustHit = True;
			SetTimer(0.02, False);
			Poolball(Other).SetTimer(0.02, False);
		}
	}
	if (Other.IsA('GolfBall'))
	{
		if (!GolfBall(Other).bJustHit)
		{
			PlaySound(sound'PoolballClack', SLOT_None);
			HitNormal = Normal(Location - Other.Location);
			Velocity = HitNormal * VSize(Other.Velocity);
			Velocity.Z = 0;
			bJustHit = True;
			GolfBall(Other).bJustHit = True;
			SetTimer(0.02, False);
			GolfBall(Other).SetTimer(0.02, False);
		}
	}
}

function Frob(Actor Frobber, Inventory frobWith)
{
    If (PowerMode == 0)
    {
	Velocity = Normal(Location - Frobber.Location) * 800;
	Velocity.Z = 0;
    }
    If (PowerMode == 1)
    {
	Velocity = Normal(Location - Frobber.Location) * 1600;
	Velocity.Z = 0;
    }
    If (PowerMode == 2)
    {
	Velocity = Normal(Location - Frobber.Location) * 2400;
	Velocity.Z = 0;
    }
    If (PowerMode == 3)
    {
	Velocity = Normal(Location - Frobber.Location) * 3200;
	Velocity.Z = 0;
    }    
    If (PowerMode == 4)
    {
       Super.Frob(Frobber, frobWith);
    }
}

defaultproperties
{
     bInvincible=True
     ItemName="Poolball"
     bPushable=False
     Physics=PHYS_Rolling
     Mesh=LodMesh'DeusExDeco.Poolball'
     CollisionRadius=1.700000
     CollisionHeight=1.700000
     bBounce=True
     Mass=5.000000
     Buoyancy=2.000000
}
